﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class CreateDeleteForm
    Private Sub cmdCreateLog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCreateLog.Click
        Try
            ' 接下来检查用户要创建的日志是否存在。
            If Not EventLog.Exists(txtLogNameToCreate.Text) Then
                ' 如果事件源已注册，则需要将其删除，
                ' 然后在调用 CreateEventSource 时重新创建它
                If EventLog.SourceExists("Event Log Sample") Then
                    EventLog.DeleteEventSource("Event Log Sample")
                End If
                EventLog.CreateEventSource("Event Log Sample", txtLogNameToCreate.Text)
                MsgBox("Event log created.")
            Else
                MsgBox("Log already exists: " & txtLogNameToCreate.Text, MsgBoxStyle.OKOnly, Me.Text & " Error")
            End If
        Catch ex As Exception
            MsgBox("Unable to create event log.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        End Try
    End Sub

    Private Sub cmdDeleteLog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDeleteLog.Click
        Try
            If EventLog.Exists(txtLogNameToDelete.Text) Then
                '然后对用户要删除的日志调用 Delete 方法。
                EventLog.Delete(txtLogNameToDelete.Text)
                MsgBox("Event log deleted.")
            Else
                MsgBox("Log does not exist: " & txtLogNameToDelete.Text, MsgBoxStyle.OKOnly, Me.Text & " Error")
            End If
        Catch ex As Exception
            MsgBox("Unable to delete event log.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        End Try
    End Sub

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class